
// adjusting detail according to distance

#macro scaleable_detail(nearo,mido,tex) 
//scaleable_detail (mushroom,mushroom,spotty_toadstool_tex) 

#declare xx=0;
#declare yy=0;
#declare zz=0;
#declare rr=seed(0);
#declare tf=1000; // transition to horizon ground
#declare tm=200; // transition to background
#declare tn=40; // transition to mid ground

#declare far_res=
 sphere { 0,1 
}

#declare mid_res=
//difference {
// sphere { 0,1 }
// cylinder { <0,0,0>,<0,2,0>,0.7 }
//}
object { mido }

#declare near_res=
object { nearo }

#declare dflt_near_res=
difference {
 sphere { 0,1 }
 cylinder { <0,0,0>,<0,2,0>,0.7 }
 cylinder { <0,0,-2>,<0,0,2>,0.3 }
 cylinder { <-2,0,0>,<2,0,0>,0.3 }
}


#declare ii=0;
#declare ee=tf*tf/100;
#declare far_expanse=
union {
#while (ii<ee)
 #declare xx=(rand(rr)-0.5)*tf*0.5;
 #declare zz=rand(rr)*tf+tm;
 #declare ii=ii+1;
 object { far_res
 translate <xx,yy,zz>
 }
#end
}

#declare ii=0;
#declare ee=tm*tm/20;
#declare mid_expanse=
union {
#while (ii<ee)
 #declare xx=(rand(rr)-0.5)*tm;
 #declare zz=rand(rr)*tm+tn;
 #declare ii=ii+1;
 object { mid_res
 translate <xx,yy,zz>
 }
#end
}

#declare ii=0;
#declare ee=tn*tn/10;
#declare near_expanse=
union {
#while (ii<ee)
 #declare xx=(rand(rr)-0.5)*tn;
 #declare zz=rand(rr)*tn;
 #declare ii=ii+1;
 object { near_res rotate (rand(rr)-0.5)*30*z
 rotate rand(rr)*360*y
 translate <xx,yy,zz>
 }
#end
}

#declare scaleable_scene=
union {
 plane { y,0 
  texture { 
   pigment  { rgb <0.3,0.4,0.3>*1.7 }
   normal { granite 0.9 scale 0.5 }
   finish { ambient 0.3 } 
  }
 }
 box {<-100000,0,tf*0.85>,<100000,0.1,1000000> // to the horizon
  texture {
   //pigment  { rgb <1,0.7,0.7>}
   //normal { bumps 0.5 scale 0.001 }  
   tex
   finish { ambient 0.6 } // tune ambient to match far_expanse
  }
 }
 //object {far_expanse} 
 object {near_expanse} 
 object {mid_expanse} 
 object {far_expanse}
 texture { 
 //pigment  { rgb <1,0.7,0.7>}
 //normal { bumps 0.5 scale 0.001 }
 //finish { ambient 0.3 } 
 tex
 }
//scale 1
//translate <0,ht-5,ds>
}

object { scaleable_scene }

#end // macro